<?php
Class Personas extends CI_Model
{
    function Index()
    {
        $this->db->select('rut,dv, nombres, ap_paterno, ap_materno');
        $this->db->from('personas');        
        $query = $this->db->get(); 
        if($query->num_rows() >= 1)
        {
          return $query->result();
        }
        else
        {
          return false;
        }
    }
    
    function CrearPersona($valores)
    {
        $this->db->insert('personas', $valores);   
        if($this->db->affected_rows() == 1)
        {
          return true;
        }
        else
        {
          return $this->db->_error_message();
        }        
    }
    function getPersona($pk)
    {
        $this->db->select('rut,dv, nombres, ap_paterno, ap_materno');
        $this->db->from('personas');        
        $this->db->where('rut',$pk);        
        $this->db->limit(1);        
        $query = $this->db->get(); 
        if($query->num_rows() >= 1)
        {
          return $query->result();
        }
        else
        {
          return false;
        }
    } 
    
    function ActualizarPersona($valores,$rut)
    {
      $this->db->where('rut',$rut);
      $this->db->update('personas', $valores);            
      if($this->db->affected_rows() == 1)
      {
        return true;
      }
      else
      {
        return $this->db->_error_message();
      }
    }      
    
    function BorrarPersona($rut)
    {
      $this->db->where('rut', $rut);
      $this->db->delete('personas'); 
      if($this->db->affected_rows() == 1)
      {
        return true;
      }
      else
      {
        return $this->db->_error_message();
      }
    }     
}